#version 330
#extension GL_EXT_gpu_shader4 : enable
// bouncing ballMod01.fsh  by mare
//https://www.shadertoy.com/view/4df3Dj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec3 sphere( vec3 dir, vec3 cam, vec3 center, float radius )
{
	if( dot(dir, center - cam ) < .0 ) return vec3( .0, .0, .0 );
	vec3 nearest = ( cam - center ) - dot( ( cam - center ), dir ) * dir;
	float dist = length( nearest );
	if( dist > radius ) return vec3( .0, .0, .0 );
	float h = sqrt( radius*radius - dist*dist );
	return center + nearest - dir * h;
}

vec2 rotate( vec2 inVec, float angle )
{
	vec2 sincos = vec2( sin(angle), cos(angle) );
	return vec2( inVec.x * sincos.y - inVec.y * sincos.x, 
				inVec.x * sincos.x + inVec.y * sincos.y );
}

float getDiffuse( vec3 diff, vec3 normal )
{
	
	float dist = length( diff );
	vec3 dir = diff / dist;
	return max( dot( dir, normal ), .0 ) /
		( 0.01 + .15 * dist* dist );
}

float getFlare( vec3 dir, vec3 camPos, vec3 lightPos, float radius )
{
	if( dot(dir, lightPos - camPos ) < .0 ) return .0;
	vec3 nearest = ( camPos - lightPos ) - dot( ( camPos - lightPos ), dir ) * dir;
	float dist = length( nearest );
	if( dist > radius ) return .0;
	float lightness = ( radius - length( nearest ) ) / radius;
	return pow( lightness, 22.0 );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy - vec2( .5, .5 );
	uv *= vec2( 1.0, .6 );
	vec3 dir = normalize( vec3( uv.x, uv.y, 1.0 ) );
	vec3 camPos = vec3( .0, 2.0, -20.0 );
	
	float mouseX = iMouse.x * .008;
	float mouseY = clamp( iMouse.y * .002, .10, .2 );
	
	camPos.yz = rotate( camPos.yz, mouseY );
	dir.yz = rotate( dir.yz, .01 + mouseY);
	
	camPos.xz = rotate( camPos.xz, mouseX );
	dir.xz = rotate( dir.xz, mouseX );
	
	float progress = 1.0 * iTime;
	float height = 2.0 * fract( 2.00 *progress) - 1.0;
	height = 1.0 - height*height;
	
	vec3 ballPos = vec3(.0, 1.0 + height * 2.0, .0 );
    float ballRadius = 1.0;
	
	vec3 lightPos = vec3( -5.0, 6.0, -4.0 ); 
	vec3 lightPos2 = vec3( 5.0, 6.0, -4.0 ); 
	vec3 lightPos3 = vec3( 0.0, 6.0, 8.0 ); 
	
	float brightness =  .0;
	float brightness2 = .0; 
	float brightness3 = .0; 
	
	lightPos.zx = rotate( lightPos.zx, 0.2 * progress);
	lightPos2.zx = rotate( lightPos2.zx, 0.2 * progress);
	lightPos3.zx = rotate( lightPos3.zx, 0.2 * progress);
	
	lightPos3.y += 2.0 * sin(       4.0 *progress );
	lightPos2.y += 2.0 * sin( 2.0 + 4.0 *progress );
	lightPos .y += 2.0 * sin( 1.0 + 4.0 *progress );
	
	vec3 sceneCollision = sphere( dir, camPos, ballPos, ballRadius );
	vec3 normal = vec3( .0, 1.0, .0 );
	
	if( length( sceneCollision ) > .01 )
	{
		normal = normalize( sceneCollision - ballPos );
		brightness = getDiffuse( lightPos - sceneCollision, normal );
		brightness2 = getDiffuse( lightPos2 - sceneCollision, normal );
		brightness3 = getDiffuse( lightPos3 - sceneCollision, normal );	
	}
	else
	{
		normal = vec3( .0, 1.0, .0 );
		
		if( dir.y < .0 )
		{
			sceneCollision = camPos - camPos.y * dir / dir.y;
			
			vec3 lightDIff = lightPos - sceneCollision;
			brightness = getDiffuse( lightDIff, normal );
			vec3 shadowCollision = sphere( 
				normalize( lightDIff) , sceneCollision, ballPos, ballRadius );
			if( length( shadowCollision ) > .001 )
			{
				brightness = .0;
			}
			
			lightDIff = lightPos2 - sceneCollision;
			brightness2 = getDiffuse( lightDIff, normal );
			shadowCollision = sphere( 
				normalize( lightDIff ), sceneCollision, ballPos, ballRadius );
			if( length( shadowCollision ) > .001 )
			{
				brightness2 = .0;
			}
			
			lightDIff = lightPos3 - sceneCollision;
			brightness3 = getDiffuse( lightDIff, normal );
			shadowCollision = sphere( 
				normalize( lightDIff ), sceneCollision, ballPos, ballRadius );
			if( length( shadowCollision ) > .001 )
			{
				brightness3 = .0;
			}
		}
	}
		
	brightness += 7.0 * getFlare( dir, camPos, lightPos, 6.0 );
	brightness2 += 7.0 * getFlare( dir, camPos, lightPos2, 6.0 );
	brightness3 += 7.0 * getFlare( dir, camPos, lightPos3, 6.0 );	
	brightness *= 0.3 + max( 18.0 * texture( iChannel0, vec2( .03, .0) ).r - 12.0, .0 );
	brightness2 *= 0.3 + max( 8.0 * texture( iChannel0, vec2( .6, .0) ).r - 2.0, .0 );
	brightness3 *= 0.3 + max( 8.0 * texture( iChannel0, vec2( .3, .0) ).r - 2.0, .0 );
	
	vec3 color = 
		brightness * vec3( 1.5, 1.0, .3) + 
		brightness2 * vec3( .7, 1.3, .3 ) + 
		brightness3 * vec3( 1.0, 0.3, 1.3 );
	
	
		
	color = pow(color, vec3( 0.4 ) ); // gamma = 2.5

	float vignette = pow( dot( uv, uv ), 1.0 );
	vignette = max( 1.0 - 1.5 * vignette, .0 );
	color *= vignette;
	
	
	gl_FragColor = vec4( color, 1.0 );
}